/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.fixup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.verification.fixup.FixupUtility;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.util.VerificationUtil;

public class FixupData {
    private List<FixupScript> m_fixupScripts = new ArrayList<FixupScript>();
    private FixupInstructions m_fixupInstructions = new FixupInstructions();
    private Hashtable<String, nodeSpecificData> m_fixableNodes = new Hashtable();
    private List<String> m_fixupGenFailedNodes = new ArrayList<String>();
    private HashMap<String, List<ErrorDescription>> m_fixupGenerationFailedNodeErrorListMap = new HashMap();

    public FixupData(List<String> participatingNodes) {
        this.addParticipatingNodes(participatingNodes);
    }

    public List<FixupScript> getFixupScriptList() {
        return this.m_fixupScripts;
    }

    public void addFixupScript(String scriptName, List<String> argumentList, String location) {
        this.addFixupScript(new FixupScript(scriptName, argumentList, location));
    }

    public void addFixupScript(String scriptName, List<String> argumentList) {
        this.addFixupScript(new FixupScript(scriptName, (List)argumentList));
    }

    public void addFixupScript(FixupScript script) {
        for (FixupScript currScript : this.m_fixupScripts) {
            if (currScript.isSameScript(script)) continue;
            this.m_fixupScripts.add(script);
        }
    }

    public void addFixupScripts(List<FixupScript> scriptList) {
        for (FixupScript script : scriptList) {
            this.addFixupScript(script);
        }
    }

    public HashMap<String, String> getFixupInstructions() {
        return this.m_fixupInstructions.getAllInstructions();
    }

    public void addFixupInstruction(String keyName, String value) {
        this.m_fixupInstructions.addInstruction(keyName, value);
    }

    public void addFixupInstructions(HashMap<String, String> instructions) {
        if (null == instructions) {
            return;
        }
        for (String name : instructions.keySet()) {
            this.addFixupInstruction(name, instructions.get(name));
        }
    }

    public void setActualValue(String node, String actualVal) {
        node = VerificationUtil.getShortHostname(node);
        this.m_fixableNodes.get(node).setActualValue(actualVal);
    }

    public void setExpectedValue(String node, String expectedVal) {
        node = VerificationUtil.getShortHostname(node);
        this.m_fixableNodes.get(node).setExpectedValue(expectedVal);
    }

    public String getActualVal(String node) {
        if (this.m_fixableNodes.containsKey(node = VerificationUtil.getShortHostname(node))) {
            return this.m_fixableNodes.get(node).getActualValue();
        }
        return "";
    }

    public String getExpectedVal(String node) {
        if (this.m_fixableNodes.containsKey(node = VerificationUtil.getShortHostname(node))) {
            return this.m_fixableNodes.get(node).getExpectedValue();
        }
        return "";
    }

    public void addParticipatingNodes(String[] nodes) {
        if (null != nodes) {
            this.addParticipatingNodes(Arrays.asList(nodes));
        }
    }

    public void addParticipatingNodes(List<String> nodeList) {
        if (null != nodeList) {
            for (String node : nodeList) {
                if (this.m_fixableNodes.containsKey(node = VerificationUtil.getShortHostname(node))) continue;
                this.m_fixableNodes.put(node, new nodeSpecificData());
            }
        }
    }

    public void addParticipatingNode(String node) {
        if (VerificationUtil.isStringGood(node = VerificationUtil.getShortHostname(node)) && !this.m_fixableNodes.contains(node)) {
            this.m_fixableNodes.put(node, new nodeSpecificData());
        }
    }

    public List<String> getParticipatingNodes() {
        ArrayList<String> participatingNodeList = new ArrayList<String>();
        if (this.m_fixableNodes.size() > 0) {
            participatingNodeList.addAll(this.m_fixableNodes.keySet());
        }
        for (String node : this.m_fixupGenFailedNodes) {
            if (participatingNodeList.contains(node)) continue;
            participatingNodeList.add(node);
        }
        return participatingNodeList;
    }

    public List<String> getFixableNodes() {
        return Arrays.asList(this.m_fixableNodes.keySet().toArray(new String[0]));
    }

    public void addFixupGenerationFailedNode(String node) {
        node = VerificationUtil.getShortHostname(node);
        this.addFixupGenerationFailedNode(node, null);
    }

    public void addFixupGenerationFailedNode(String node, ErrorDescription error) {
        if (VerificationUtil.isStringGood(node)) {
            if (this.m_fixupGenerationFailedNodeErrorListMap.containsKey(node = VerificationUtil.getShortHostname(node))) {
                if (null != error && !this.m_fixupGenerationFailedNodeErrorListMap.get(node).contains(error)) {
                    this.m_fixupGenerationFailedNodeErrorListMap.get(node).add(error);
                }
            } else {
                ArrayList<ErrorDescription> errorList = new ArrayList<ErrorDescription>();
                if (null != error) {
                    errorList.add(error);
                }
                this.m_fixupGenerationFailedNodeErrorListMap.put(node, errorList);
            }
            if (!this.m_fixupGenFailedNodes.contains(node)) {
                this.m_fixupGenFailedNodes.add(node);
            }
        }
    }

    public List<String> getFixupGenerationFailedNodes() {
        return Arrays.asList(this.m_fixupGenerationFailedNodeErrorListMap.keySet().toArray(new String[0]));
    }

    public boolean isFixupGenerationFailed() {
        return this.m_fixupGenerationFailedNodeErrorListMap.size() > 0;
    }

    public boolean isFixupGenerationFailedForNode(String node) {
        node = VerificationUtil.getShortHostname(node);
        return this.m_fixupGenerationFailedNodeErrorListMap.containsKey(node);
    }

    public boolean isFixupGenerationFailedOnAllNodes() {
        return this.m_fixupGenerationFailedNodeErrorListMap.keySet().containsAll(this.m_fixableNodes.keySet());
    }

    public List<ErrorDescription> getFixupGenerationFailedErrors(String node) {
        if (this.m_fixupGenerationFailedNodeErrorListMap.containsKey(node = VerificationUtil.getShortHostname(node))) {
            return this.m_fixupGenerationFailedNodeErrorListMap.get(node);
        }
        return new ArrayList<ErrorDescription>();
    }

    public void uploadFixupData(FixupData fixData) {
        if (fixData == null || this.isSameFixupData(fixData, false)) {
            return;
        }
        this.addParticipatingNodes(fixData.getParticipatingNodes());
        this.addFixupScripts(fixData.getFixupScriptList());
        this.addFixupInstructions(fixData.getFixupInstructions());
        for (String node : fixData.getParticipatingNodes()) {
            this.setActualValue(node, fixData.getActualVal(node));
            this.setExpectedValue(node, fixData.getExpectedVal(node));
        }
        for (String node : fixData.getFixupGenerationFailedNodes()) {
            for (ErrorDescription err : fixData.getFixupGenerationFailedErrors(node)) {
                this.addFixupGenerationFailedNode(node, err);
            }
        }
    }

    public boolean isSameFixupData(FixupData fixData, boolean ignoreMissMatchingNodes) {
        if (fixData == null) {
            return false;
        }
        Trace.out((String)"Checking if the fix-up data is same or not");
        boolean isSame = true;
        if (!fixData.getParticipatingNodes().containsAll(this.getParticipatingNodes()) || this.getParticipatingNodes().size() != fixData.getParticipatingNodes().size()) {
            Trace.out((String)"fix-up data is not same as the participating nodes are different");
            isSame = ignoreMissMatchingNodes;
        }
        if (isSame) {
            for (String node : fixData.getParticipatingNodes()) {
                if (fixData.getActualVal(node).equals(this.getActualVal(node)) && fixData.getExpectedVal(node).equals(this.getExpectedVal(node))) continue;
                Trace.out((String)"fix-up data is not same as the node-wise actual/expected values are different");
                isSame = false;
                break;
            }
        }
        if (isSame && fixData.getFixupScriptList().size() == this.getFixupScriptList().size()) {
            for (FixupScript script : fixData.getFixupScriptList()) {
                boolean match = false;
                for (FixupScript currScript : this.getFixupScriptList()) {
                    if (!currScript.isSameScript(script)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                Trace.out((String)"fix-up data is not same as the Fix-up Scripts are different");
                isSame = false;
                break;
            }
        } else {
            Trace.out((String)"fix-up data is not same as the number of Fix-up Scripts is different");
            isSame = false;
        }
        if (isSame && fixData.getFixupInstructions().size() == this.getFixupInstructions().size()) {
            for (String key : fixData.getFixupInstructions().keySet()) {
                if (this.m_fixupInstructions.containsInstruction(key, fixData.getFixupInstructions().get(key))) continue;
                Trace.out((String)"fix-up data is not same as the Fix-up Instructions are different");
                isSame = false;
                break;
            }
        } else {
            Trace.out((String)"fix-up data is not same as the number of Fix-up instructions is different");
            isSame = false;
        }
        return isSame;
    }

    private class FixupInstructions {
        private HashMap<String, String> m_fixupInstructionsKeyValPair = new HashMap();

        private FixupInstructions() {
        }

        public void addInstruction(String name, String value) {
            if (VerificationUtil.isStringGood(name) && VerificationUtil.isStringGood(value) && !this.containsInstruction(name, value)) {
                this.m_fixupInstructionsKeyValPair.put(name, value);
            }
        }

        public HashMap<String, String> getAllInstructions() {
            return this.m_fixupInstructionsKeyValPair;
        }

        public boolean containsInstruction(String name, String value) {
            return this.m_fixupInstructionsKeyValPair.containsKey(name) && this.m_fixupInstructionsKeyValPair.get(name).equals(value);
        }
    }

    private class nodeSpecificData {
        private String m_expectedValue = null;
        private String m_actualValue = null;

        private nodeSpecificData() {
            this("", "");
        }

        private nodeSpecificData(String expectedVal, String actualVal) {
            this.m_expectedValue = !VerificationUtil.isStringGood(expectedVal) ? "" : expectedVal;
            this.m_actualValue = !VerificationUtil.isStringGood(actualVal) ? "" : actualVal;
        }

        public String getActualValue() {
            return this.m_actualValue;
        }

        public String getExpectedValue() {
            return this.m_expectedValue;
        }

        public void setActualValue(String actualVal) {
            if (VerificationUtil.isStringGood(actualVal)) {
                this.m_actualValue = actualVal;
            }
        }

        public void setExpectedValue(String expectedVal) {
            if (VerificationUtil.isStringGood(expectedVal)) {
                this.m_expectedValue = expectedVal;
            }
        }
    }

    public static class FixupScript {
        private String m_scriptName = null;
        private List<String> m_argumentList = null;
        private String m_location = null;

        private FixupScript(String scriptName, List<String> argumentList) {
            this(scriptName, argumentList, null);
        }

        private FixupScript(String scriptName, List<String> argumentList, String location) {
            this.m_scriptName = scriptName;
            this.m_argumentList = argumentList != null ? argumentList : new ArrayList<String>();
            this.m_location = VerificationUtil.isStringGood(location) ? location : FixupUtility.getDefaultFixupScriptsLocation();
            if (!this.m_location.endsWith(Constants.FILE_SEPARATOR)) {
                this.m_location = this.m_location + Constants.FILE_SEPARATOR;
            }
        }

        public String getScriptCompletePath() {
            return this.m_location + this.m_scriptName;
        }

        public String getLocation() {
            return this.m_location;
        }

        public String getScriptName() {
            return this.m_scriptName;
        }

        public List<String> getArgumentList() {
            return this.m_argumentList;
        }

        public boolean isSameScript(FixupScript script) {
            return null != script && this.m_scriptName != null && script.getScriptName() != null && script.getScriptName().equals(this.m_scriptName) && script.getLocation().equals(this.m_location) && script.getArgumentList().containsAll(this.m_argumentList) && script.getArgumentList().size() == this.m_argumentList.size();
        }
    }
}

